"""Testing for broker"""
import sys
import requests
import json
from urllib.parse import quote_plus


models_to_id = {
    "runwayml/stable-diffusion-v1-5": None,
    "stabilityai/stable-diffusion-2-1-base": None,
    "stabilityai/stable-diffusion-2-depth": None,
    "stabilityai/stable-diffusion-2-inpainting": None,
    "runwayml/stable-diffusion-inpainting": None,
    "timbrooks/instruct-pix2pix": None,
    "reimager/AbyssOrangeMix3": 9942,
    "wavymulder/Analog-Diffusion": 1265,
    "andite/anything-v4.0": None,
    "XpucT/Deliberate": 4823,
    "Lykon/DreamShaper": 4384,
	"ItsJayQz/GTA5_Artwork_Diffusion": 1309,
	"hassanblend/HassanBlend1.5.1.2": 1173,
	"reimager/HRL": 8616,
	"nitrosocke/Nitro-Diffusion": 1045,
	"prompthero/openjourney-v2": None,
	"naclbit/trinart_stable_diffusion_v2": None,
	"naclbit/trinart_characters_19.2m_stable_diffusion_v1": None,
	"reimager/URPM": 2661,
}

def get_model_json(model_id):
    """Call ping"""
    headers = {'content-type': 'application/json'}
    response = requests.get(f"https://civitai.com/api/v1/models/{model_id}", headers=headers)
    if response.status_code != 200:
        print(f"Invalid response {response.status_code} {model_id}")
        sys.exit(1)
    return response.json()


def get_model_samples(model_id):
    images = []
    js = get_model_json(model_id)
    if js.get('modelVersions') is None:
        print(f"model {model_id} missing modelVersions")
        sys.exit(1)
    for model_version in js.get('modelVersions'):
        if model_version.get('images') is None:
            continue
        model_version_images = model_version['images']
        for image in model_version_images:
            #if image.get('nsfw') is True:
                #print(image.get('nsfw'))
            if image.get('meta') is None:
                continue
            if image.get('meta').get('prompt') is None:
                continue
            images.append(image)
    return images


for model in models_to_id:
    model_id = models_to_id[model]
    if model_id is None:
        continue
    samples = get_model_samples(models_to_id[model])
    print()
    print()
    print()
    print(model)
    print()
    print(json.dumps(samples, indent=2))
