"""custom nodes init"""
from .class_info import SegmentationClassConfig, SegmentationClassStack, SegmentationClassAggregator
from .histogram_matching import LABHistogramMatcher
from .paint.paint import Paint
from .classify_room import Classify_Room
from .highlight_mask import HighlightMaskBorder
from .process_mask import RemoveSmallMaskRegions, CombineMaskFromListMasks
from .verify_mask import VerifyMask
from .refine_mask import RefineMask
from .segmentation_processor import SegmentationProcessor
from .deeplab import LoadDeepLabV3, ApplyDeepLabV3


NODE_CLASS_MAPPINGS = {
    "SegmentationClassConfig": SegmentationClassConfig,
    "SegmentationClassStack": SegmentationClassStack,
    "SegmentationClassAggregator": SegmentationClassAggregator,
    "SegmentationProcessor": SegmentationProcessor,
    "LABHistogramMatching": LABHistogramMatcher,
    "Paint": Paint,
    "Classify_Room": Classify_Room,
    "HighlightMaskBorder": HighlightMaskBorder,
    "RemoveSmallMaskRegions": RemoveSmallMaskRegions,
    "VerifyMask": VerifyMask,
    "RefineMask": RefineMask,
    "LoadDeepLabV3": LoadDeepLabV3,
    "ApplyDeepLabV3": ApplyDeepLabV3,
    "CombineMaskFromListMasks": CombineMaskFromListMasks,
}

NODE_DISPLAY_NAME_MAPPINGS = {
    "SegmentationClassConfig": "Segmentation Class Definition",
    "SegmentationClassStack": "Stack Segmentation Classes",
    "SegmentationClassAggregator": "Aggregate Segmentation Classes",
    "SegmentationProcessor": "Segmentation Processor",
    "LABHistogramMatching": "LAB Histogram Matching",
    "Paint Color" : "Paint",
    "Classify_Room": "Classify Room",
    "HighlightMaskBorder": "Highlight Mask Border",
    "RemoveSmallMaskRegions": "Remove Small Mask Regions",
    "VerifyMask": "Verify Mask",
    "RefineMask": "Refine Mask",
    "LoadDeepLabV3": "Load DeepLab V3",
    "ApplyDeepLabV3": "Apply DeepLab V3",
    "CombineMaskFromListMasks": "Combine Mask From List Masks",
}
