import cv2
import uuid

def tmpname(prefix="tmpfile", suffix=".tmp"):
    random=uuid.uuid4().hex[:8]
    return f"/tmp/{prefix}{random}{suffix}"

def check_image_sizes(**kwargs):
    """
    verifies that all images passed are the same size and SD compatible
    if not, an description exception will be thrown
    return the width, height of all images
    """
    if len(kwargs) < 1:
        raise Exception("image required")
    cvimg = cv2.imread(kwargs["image"])
    if cvimg is None:
        raise Exception("bad image format: image")
    height, width, _ = cvimg.shape
    for name, img in kwargs.items():
        if name == "image":
            # already checked the image
            continue
        if name == "style_image":
            # style_image can be any size and need not match image
            continue
        if img is None:
            continue
        cvimg = cv2.imread(img)
        if cvimg is None:
            raise Exception(f"bad image format: {name}")
        h, w, _ = cvimg.shape
        if h % 64 != 0 or w % 64 != 0:
            raise Exception(f"image dimensions unsupported: {w}x{h}")
        if h != height or w != width:
            raise Exception(f"image dimensions differ: {width}x{height} {w}x{h}")
    return (width, height)
