import torch
import numpy as np

class VerifyMask:
    @classmethod
    def INPUT_TYPES(cls):
        return {
            "required": {
                "mask": ("MASK",),
                "min_masked_pixels": ("INT", {
                    "default": 10,
                    "min": 0
                }),
            }
        }

    RETURN_TYPES = ("MASK",)
    FUNCTION = "execute"
    CATEGORY = "ReImage AI"

    def mask_to_numpy(self, mask_tensor: torch.Tensor) -> np.ndarray:
        """Convert ComfyUI mask tensor (H, W) to numpy array (H, W)."""
        mask_np = mask_tensor.cpu().numpy()
        mask_np = (mask_np * 255).clip(0, 255).astype(np.uint8)
        return mask_np

    def execute(self, mask, min_masked_pixels):
        mask_np = self.mask_to_numpy(mask)
        masked_pixel_count = np.sum(mask_np > 0)
        if masked_pixel_count < min_masked_pixels:
            raise Exception(f"Invalid Mask: Not enough pixels masked ({masked_pixel_count} pixels)")

        return (mask,)
