"""Testing for comfy-service"""
# pylint: disable=bare-except
# pylint: disable=broad-exception-raised
import os
import sys
import argparse
import signal
import traceback
import io
from service import launch_comfy, terminate_comfy
from test_cases import create_sets

# This is the default seed iterator used by many test suites
SEED_LIST=[1]

# If quick mode only run the first test case from each suite
QUICK_MODE=False

# the output buffer for the comfy subproc stdout
comfy_output_buffer = io.StringIO()



def parse_args(argv):
    '''parse command line arguments'''
    # pylint: disable=global-statement
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-s", "--seed", type=int, default=1)
    parser.add_argument("-f", "--files", type=int, default=0)
    parser.add_argument("-q", "--quick", action='store_true')
    parser.add_argument("otherthings", nargs=argparse.REMAINDER)
    options = parser.parse_args(argv)

    global SEED_LIST
    SEED_LIST = list(range(options.seed))
    global QUICK_MODE
    QUICK_MODE = options.quick

    return options.otherthings


def exit_cleanup():
    '''cleanup and exit'''
    try:
        terminate_comfy()
    except:
        traceback.print_exc(file=sys.stdout)
    # pylint: disable=protected-access
    os._exit(0)


def signal_handler(_, __):
    '''signal handler'''
    exit_cleanup()


def main():
    '''main'''
    signal.signal(signal.SIGINT, signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    launch_comfy(output=comfy_output_buffer)

    sets_to_run = parse_args(sys.argv[1:])
    if len(sets_to_run) == 0:
        sets_to_run = [""] # run all suites
    sets = create_sets(SEED_LIST)

    test_count = 0
    try:
        for name_substring in sets_to_run:
            for testset in sets:
                if name_substring in testset.name:
                    success, count = testset.run(comfy_output_buffer, quick=QUICK_MODE)
                    test_count = test_count + count
                    if not success:
                        exit_cleanup()
        print(f"ALL TESTS PASSED {test_count}")
    except:
        traceback.print_exc(file=sys.stdout)

    exit_cleanup()



if __name__ == "__main__":
    main()
