"""run a config"""
# pylint: disable=bare-except
# pylint: disable=too-many-nested-blocks
import os
import sys
import signal
import traceback
import shutil
from service import launch_comfy, terminate_comfy
from config_runner import run_inputs

def main():
    """main"""
    launch_comfy()

    os.makedirs("./output-wall", exist_ok=True)

    simple_wall_testcases = [
        ("../test-images/reskin/wall.png", "../test-images/reskin/wall.mask.png", "blue wall"),
        ("../test-images/reskin/wall.png", "../test-images/reskin/wall.mask.png", "red brick wall"),
    ]

    for seed in range(1):
        for i, (image, mask_image, prompt) in enumerate(simple_wall_testcases):
            base = os.path.basename(image).split(".")[0]
            inputs = {
                "op": "wall",
                "image": image,
                "mask_image": mask_image,
                "prompt": prompt,
                "seed": seed,
            }
            results = run_inputs(inputs)
            print(results)
            for key, value in results.items():
                if not isinstance(value, str):
                    continue
                if not os.path.exists(value):
                    continue
                if os.stat(value).st_size == 0:
                    continue  # skip if empty
                outputname = f"./output-wall/output-{inputs['op']}-{i}-{base}-{inputs['seed']:03d}{os.path.splitext(value)[1]}"
                print(f"Saving {key} to {outputname}")
                shutil.copy(value, outputname)


def exit_cleanup():
    """cleanup and exit"""
    try:
        terminate_comfy()
    except:
        traceback.print_exc(file=sys.stdout)
    # pylint: disable=protected-access
    os._exit(0)


def signal_handler(_, __):
    """signal handler"""
    exit_cleanup()


if __name__ == "__main__":
    signal.signal(signal.SIGINT, signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    main()
    exit_cleanup()
