import json
import re

class Classify_Room:
    @classmethod
    def INPUT_TYPES(cls):
        return {
            "required": {
                "room_types": ("STRING", ),
                "confidence_score": ("FLOAT", ),
                "threshold": ("FLOAT", ),
                "restrict_room_types": ("STRING", ),
            }
        }
    
    RETURN_TYPES = ()
    OUTPUT_NODE = True
    FUNCTION = "execute"
    CATEGORY = "ReImage AI"
    
    def execute(self, room_types, confidence_score, threshold, restrict_room_types):
        results = {"result": []}
        if (confidence_score >= threshold and room_types.lower() != restrict_room_types.lower().strip()):
            results["result"] = [(room_types, confidence_score)]
        return {"ui": {"json_string": (json.dumps(results),)}}
