#!/bin/sh

repoName="comfy-service"
imgName="reimage/comfy:datacenter"

# if GPU not specified, just use all
if [ -z "$GPU" ] ; then
   GPU="all"
fi

extra_opts=""

cmd="python3 /usr/local/src/$repoName/src/service.py $*"

if [ "$1" = "zsh" ] ; then
    homedir="/tmp"
    extra_opts="-it -v $HOME/.zshrc:$homedir/.zshrc -v $HOME/.zsh_history:$homedir/.zsh_history -u $(id -u):$(id -g) -v $HOME/.Xauthority:/root/.Xauthority:rw --env=\"DISPLAY\" -h $repoName"
    cmd="zsh"
fi

# -v /mldata/huggingface:$homedir/.cache/huggingface \
exec docker run \
     --rm \
     --gpus $GPU \
     --ipc=host \
     --ulimit memlock=-1 \
     --ulimit stack=67108864 \
     $extra_opts \
     $override_opt \
     $imgName \
     "$cmd"

