"""Just launches comfy"""
# pylint: disable=bare-except
# pylint: disable=broad-exception-raised
import os
import sys
import signal
import traceback
import time
from service import launch_comfy, terminate_comfy

def exit_cleanup():
    '''cleanup and exit'''
    try:
        terminate_comfy()
    except:
        traceback.print_exc(file=sys.stdout)
    # pylint: disable=protected-access
    os._exit(0)


def signal_handler(_, __):
    '''signal handler'''
    exit_cleanup()


def main():
    '''main'''
    signal.signal(signal.SIGINT, signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    launch_comfy()

    while True:
        time.sleep(60)

    exit_cleanup()


if __name__ == "__main__":
    main()
