"""run a config"""
# pylint: disable=bare-except
import os
import sys
import argparse
import shutil
import signal
import traceback
from pathlib import Path
from service import launch_comfy, terminate_comfy
import config_manager

def main():
    """main"""
    parser=argparse.ArgumentParser()
    parser.add_argument('-i','--input', action='append', nargs=2, metavar=('name','value'), help='help:')
    parser.add_argument('-o','--output', default="", type=str)
    parserargs = parser.parse_args()

    inputs = {}
    for name,value in parserargs.input:
        fullpath = os.path.join(os.getcwd(),value)
        if os.path.isfile(fullpath):
            value = Path(fullpath)
        inputs[name] = value

    launch_comfy()

    results = config_manager.run_inputs(inputs)

    for key, value in results.items():
        if not isinstance(value, str):
            continue
        if not os.path.exists(value):
            continue
        if os.stat(value).st_size == 0:
            continue # skip if empty
        outputname = f"./{parserargs.output}{os.path.basename(value)}"
        print(f"Saving {key} to {outputname}")
        shutil.copy(value, outputname)


def exit_cleanup():
    """cleanup and exit"""
    try:
        terminate_comfy()
    except:
        traceback.print_exc(file=sys.stdout)
    # pylint: disable=protected-access
    os._exit(0)


def signal_handler(_, __):
    """signal handler"""
    exit_cleanup()


if __name__ == "__main__":
    signal.signal(signal.SIGINT, signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    main()
    exit_cleanup()
