"""landscaping functions"""
import re
import logging
logging.basicConfig(level=logging.ERROR)
logger = logging.getLogger(__name__)

import reimage
import subproc
import subproc_util
import pipelines
from util import check_image_sizes
from operations import (
    inpainting,
)

def remodel_landscaping(
    job_id,
    preset,
    prompt,
    negative_prompt,
    image,
    mask_image,
    style_image,
    batch_size,
    seed,
    fidelity,
):
    if job_id is None:
        raise Exception("job_id is required")
    if image is None:
        raise Exception("image is required")
    if mask_image is None:
        raise Exception("mask image is required")
    if prompt is None and style_image is None and preset is None:
        raise Exception("prompt, style_image, or preset required")

    if negative_prompt is None:
        negative_prompt = "anime, cartoon, graphic, text, crayon, glitch, blur, ugly, deformed, blurry, watermark, disfigured"

    check_image_sizes(image=image, mask_image=mask_image)

    if prompt is None and preset is not None:
        # Craft a prompt from the preset
        preset = re.sub('(.)([A-Z][a-z]+)', r'\1 \2', preset).lower()
        prompt = f"A home with {preset} landscaping, beautiful, photorealistic"

    if style_image is None:
        pipeline = "sdxl_inpainting"
        args = {
            "prompt": prompt,
            "negative_prompt": negative_prompt,
            "input_image": image,
            "mask_image": mask_image,
            "batch_size": batch_size,
            "steps": 25,
            "guidance_scale": 7.5,
            "seed": seed,
            "overmask": True,
        }
    else:
        pipeline = "sdxl_inpainting_ip_adapter"
        args = {
            "prompt": prompt,
            "ip_adapter_image": style_image,
            "ip_adapter_scale": fidelity,
            "batch_size": batch_size,
            "steps": 25,
            "guidance_scale": 10.0,
            "strength": 0.999,
            "seed": seed,
            "negative_prompt": negative_prompt,
            "scheduler": "dpms",
            "input_image": image,
            "mask_image": mask_image,
            "overmask": True,
        }
    subproc_util.subproc_launch(pipeline, job_id, fn=pipelines.pipeline_get_loader(pipeline))
    reimage.update_job(job_id, 'rendering')
    result = subproc.subproc_call(pipeline, inpainting, args=args)
    if isinstance(result, BaseException):
        raise result
    return result
