"""interior remodel functions"""

import reimage
import subproc
import subproc_util
import pipelines
from util import check_image_sizes
from operations import (
    inpainting,
)


def remodel_replace(
    job_id,
    prompt,
    negative_prompt,
    image,
    mask_image,
    style_image,
    fidelity,
    batch_size,
    seed,
):
    if job_id is None:
        raise Exception("job_id is required")
    if image is None:
        raise Exception("image is required")
    if mask_image is None:
        raise Exception("mask image is required")

    fidelity = 0.65 if float is None else float(fidelity)
    prompt = "" if prompt is None else prompt
    negative_prompt = "" if negative_prompt is None else negative_prompt

    check_image_sizes(image=image, mask_image=mask_image, style_image=style_image)

    if style_image is None:
        pipeline = "sdxl_inpainting"
        args = {
            "prompt": prompt,
            "negative_prompt": negative_prompt,
            "input_image": image,
            "mask_image": mask_image,
            "batch_size": batch_size,
            "steps": 25,
            "guidance_scale": 10.0,
            "seed": seed,
            "overmask": True,
        }
        subproc_util.subproc_launch(
            pipeline, job_id, fn=pipelines.pipeline_get_loader(pipeline)
        )
        reimage.update_job(job_id, "rendering")
        result = subproc.subproc_call(pipeline, inpainting, args=args)
    else:
        pipeline = "sdxl_inpainting_ip_adapter"
        args = {
            "prompt": prompt,
            "ip_adapter_image": style_image,
            "ip_adapter_scale": fidelity,
            "batch_size": batch_size,
            "steps": 25,
            "guidance_scale": 10.0,
            "strength": 0.999,
            "seed": seed,
            "negative_prompt": negative_prompt,
            "scheduler": "dpms",
            "input_image": image,
            "mask_image": mask_image,
            "overmask": True,
        }
        subproc_util.subproc_launch(
            pipeline, job_id, fn=pipelines.pipeline_get_loader(pipeline)
        )
        reimage.update_job(job_id, "rendering")
        result = subproc.subproc_call(pipeline, inpainting, args=args)

    if isinstance(result, BaseException):
        raise result
    return result
