"""run a config"""
# pylint: disable=bare-except
import os
os.environ["HF_HOME"] = "/mldata/huggingface"
os.environ["HF_TOKEN"] = "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"
os.environ["TORCH_HOME"] = "/mldata/torch"
os.environ["NLTK_DATA"] = "/mldata/nltk_data"
import sys
import argparse
import shutil
import signal
import traceback
import models
import service
from pathlib import Path

def main():
    """main"""
    parser=argparse.ArgumentParser()
    parser.add_argument('-i','--input', action='append', nargs=2, metavar=('name','value'), help='help:')
    parser.add_argument('-o','--output', default="", type=str)
    parserargs = parser.parse_args()

    inputs = {}
    for name,value in parserargs.input:
        fullpath = os.path.join(os.getcwd(),value)
        if os.path.isfile(fullpath):
            value = Path(fullpath)
        inputs[name] = value

    models.load_models()

    results = service.run_inputs(inputs)

    for key, value in results.items():
        if not isinstance(value, str):
            continue
        if not os.path.exists(value):
            continue
        if os.stat(value).st_size == 0:
            continue # skip if empty
        outputname = f"./{parserargs.output}{os.path.basename(value)}"
        print(f"Saving {key} to {outputname}")
        shutil.copy(value, outputname)


if __name__ == "__main__":
    signal.signal(signal.SIGINT, service.signal_handler)
    signal.signal(signal.SIGTERM, service.signal_handler)

    main()
    service.exit_cleanup()
