"""Testing for comfy-service"""
# pylint: disable=bare-except
# pylint: disable=broad-exception-raised
import os
os.environ["HF_HOME"] = "/mldata/huggingface"
os.environ["HF_TOKEN"] = "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"
os.environ["TORCH_HOME"] = "/mldata/torch"
os.environ["NLTK_DATA"] = "/mldata/nltk_data"
import sys
import argparse
import signal
import traceback
import io
import models
import requests
import multiprocessing as mp
import service
import subproc
from test_cases import create_sets

# This is the default seed iterator used by many test suites
SEED_LIST=[1]

# If quick mode only run the first test case from each suite
QUICK_MODE=False


parent=False


def parse_args(argv):
    '''parse command line arguments'''
    # pylint: disable=global-statement
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-s", "--seed", type=int, default=1)
    parser.add_argument("-q", "--quick", action='store_true')
    parser.add_argument("otherthings", nargs=argparse.REMAINDER)
    options = parser.parse_args(argv)

    global SEED_LIST
    SEED_LIST = list(range(options.seed))
    global QUICK_MODE
    QUICK_MODE = options.quick

    return options.otherthings

def signal_handler(sig, _):
    exit_cleanup(sig)

def exit_cleanup(sig=None, code=0, requeue=True):
    try:
        for process_name in subproc.subprocs:
            subproc.subprocs[process_name]["job_queue"].put(None)

        print(f"\n\nExiting...", flush=True)
        # pylint: disable=protected-access
        os._exit(code)
    except:
        traceback.print_exc(file=sys.stdout)

def main():
    '''main'''
    signal.signal(signal.SIGINT, signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    mp.set_start_method('spawn', force=True)
    models.load_models()
    parent = True

    sets_to_run = parse_args(sys.argv[1:])
    if len(sets_to_run) == 0:
        sets_to_run = [""] # run all suites
    sets = create_sets(SEED_LIST)

    test_count = 0
    try:
        for name_substring in sets_to_run:
            for testset in sets:
                if name_substring in testset.name:
                    success, count = testset.run(quick=QUICK_MODE)
                    test_count = test_count + count
                    if not success:
                        exit_cleanup()
        print(f"ALL TESTS PASSED {test_count}")
    except:
        traceback.print_exc(file=sys.stdout)

    exit_cleanup()



if __name__ == "__main__":
    main()
