#!/bin/sh

repoName="Real-ESRGAN"
procName="real-esrgan"
imgName="reimage/real-esrgan:latest"

homedir="/tmp/$procName-home/"
mkdir -p $homedir
chmod 777 $homedir

extra_opts=""
cmd="python3 /usr/local/src/$repoName/$procName.service.py $*"
if [ "$1" = "zsh" ] ; then
    extra_opts="-it -v $HOME/.zshrc:$homedir/.zshrc -v $HOME/.zsh_history:$homedir/.zsh_history -u $(id -u):$(id -g) -v $HOME/.Xauthority:/root/.Xauthority:rw --env=\"DISPLAY\" -h $repoName"
    cmd="zsh"
fi

override_opt=""
if [ -d "$HOME/$repoName" ] ; then
    REPODIR="$HOME/$repoName"
    echo "Overriding /usr/local/src/$repoName with $REPODIR"
    override_opt="-v $REPODIR:/usr/local/src/$repoName -v $REPODIR:/workspace"
fi

exec docker run \
	   --rm \
       --gpus all \
	   --ipc=host \
	   --ulimit memlock=-1 \
	   --ulimit stack=67108864 \
	   -e HOME=$homedir \
	   -e TORCH_HOME=/mldata/torch-home \
	   -v /tmp:/tmp \
	   -v /mldata:/mldata \
	   -u reimage:reimage \
       $extra_opts \
       $override_opt \
       $imgName \
       $cmd
